function [m sd se f] = eventsOverTime(eventTimes, maxTime, winWidth, ...
                numInSec, eventName, plotGraph)
% eventsOverTime.m
%
% This program takes a cell vector of vectors as input.  
% The values in the vector are expected to be the times that an 
% event occurred.  As output, it generates a figure plotting 
% events/sec as a function of time.
%
% Arguments:
%   eventTimes: the cellArray to analyze
%   winWidth: the width of the moving average window to use
%   numInSec: the number of time units in a second
%   eventName: the name of the event (e.g. "pumps")

%maxLength = 0;
%for i=1:length(eventTimes)
%    maxLength = max(maxLength, length(eventTimes{i}));
%end

lw = 2;

data = zeros(length(eventTimes), maxTime - (winWidth-1));
b = ones(1,winWidth) / winWidth;

% Take moving averages first, so I can calculate the SD as well as the mean
for i=1:length(eventTimes)
    eventTimes{i} = eventTimes{i}(eventTimes{i} > 0);    
    eventTimes{i} = eventTimes{i}(eventTimes{i} <= maxTime);
    v = zeros(1,maxTime);
    v(eventTimes{i}) = v(eventTimes{i}) + 1;
    data(i,:) = conv(v, b, 'valid');
end

m = mean(data,1) * numInSec;
sd = std(data,0,1) * numInSec;
se = sd ./ sqrt(size(data,1));

if(plotGraph)  % TODO: add support for std
    f = figure;
    plot((1/numInSec):(1/numInSec):((maxTime+1)/numInSec-1), m, 'LineWidth', lw);
    title(strcat(eventName, 's per sec'));
    xlabel('time (s)');
    prettify();
end

end